package ru.yandex.travel.hotels.cluster_permalinks;

import lombok.RequiredArgsConstructor;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.stereotype.Component;

@Component
@RequiredArgsConstructor
@ConditionalOnEnabledHealthIndicator("cluster-permalinks")
public class ClusterPermalinkServiceHealthIndicator implements HealthIndicator {
    private final ClusterPermalinkService clusterPermalinkService;

    @Override
    public Health health() {
        if (clusterPermalinkService.isReady()) {
            return Health.up().build();
        } else {
            return Health.down().build();
        }
    }
}

