package ru.yandex.travel.hotels.common;

import java.util.ArrayList;
import java.util.List;

import com.google.common.base.Preconditions;
import lombok.Getter;

public class Ages {
    public static final int MIN_ADULTS = 1;
    public static final int MAX_ADULTS = 10;
    public static final int MIN_CHILD_AGE = 0;
    public static final int MAX_CHILD_AGE = 17;


    @Getter
    private final int adults;
    @Getter
    private final List<Integer> childrenAges;

    private Ages(int adults, List<Integer> childrenAges) {
        Preconditions.checkArgument(adults >= MIN_ADULTS, "Not enough adults");
        Preconditions.checkArgument(adults <= MAX_ADULTS, "Too much adults");
        this.adults = adults;
        this.childrenAges = childrenAges;
    }

    public static Ages build(int adults, List<Integer> childrenAges) {
        return new Ages(adults, childrenAges);
    }

    public static Ages fromString(String ages) {
        int numAdults = 0;
        List<Integer> childAges = new ArrayList<>();
        for (String age: ages.split(",")) {
            if ("88".equals(age)) {
                ++numAdults;
            } else {
                childAges.add(Integer.valueOf(age));
            }
        }
        return new Ages(numAdults, childAges);
    }

    @Override
    public String toString() {
        StringBuilder bldr = null;
        Preconditions.checkArgument(adults > 0);
        for (int i = 0; i < adults; i++) {
            if (bldr == null) {
                bldr = new StringBuilder("88");
            } else {
                bldr.append(",88");
            }
        }
        if (childrenAges != null) {
            for (int age : childrenAges) {
                bldr.append(',');
                bldr.append(age);
            }
        }
        return bldr.toString();
    }
}
