package ru.yandex.travel.hotels.common;

public enum LanguageType {
    ru("ru"),
    en("en"),
    tr("tr");

    private final String value;

    LanguageType(String str) {
        this.value = str;
    }

    public String getShortLanguage() {
        return this.value;
    }

    public String getFullLocale() {
        switch (this) {
            case ru:
                return "ru_RU";
            case en:
                return "en_US";
            case tr:
                return "tr_TR";
            default:
                return "ru_RU";
        }
    }
}
