package ru.yandex.travel.hotels.common;

import java.util.Objects;

public class Permalink {
    private final long value;

    private Permalink(long v) {
        value = v;
    }

    public static Permalink of(String v) {
        try {
            return new Permalink(Long.parseUnsignedLong(v));
        } catch (NumberFormatException e) {
            throw new IllegalArgumentException(e);
        }
    }
    public static Permalink of(long v) {
        return new Permalink(v);
    }

    public long asLong() {
        return value;
    }

    @Override
    public String toString() {
        return Long.toUnsignedString(value);
    }

    @Override
    public boolean equals(Object o) {
        return (o instanceof Permalink) && (((Permalink) o).value == value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }
}
