package ru.yandex.travel.hotels.common;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

import ru.yandex.bolts.collection.Tuple2;

public class UpdatableDataHolder<T> {
    private final AtomicReference<Tuple2<CompletableFuture<T>, Instant>> data;
    private final Duration ttl;
    private final Duration retryInterval;
    private final Supplier<CompletableFuture<T>> supplier;

    public UpdatableDataHolder(Duration ttl, Duration retryInterval, Supplier<CompletableFuture<T>> supplier) {
        this.ttl = ttl;
        this.retryInterval = retryInterval;
        this.supplier = supplier;
        data = new AtomicReference<>(null);
    }

    public CompletableFuture<T> get() {
        var tuple = data.get();
        if (tuple == null ||
                tuple.get2().isBefore(Instant.now().minus(ttl.toMillis(), ChronoUnit.MILLIS)) ||
                (tuple.get1().isCompletedExceptionally() &&
                        tuple.get2().isBefore(Instant.now().minus(retryInterval.toMillis(), ChronoUnit.MILLIS)))) {
            Tuple2<CompletableFuture<T>, Instant> newTuple = Tuple2.tuple(supplier.get(), Instant.now());
            if (data.compareAndSet(tuple, newTuple)) {
                return newTuple.get1();
            } else {
                return data.get().get1();
            }
        } else {
            return tuple.get1();
        }
    }

    public void evict() {
        data.set(null);
    }
}
