package ru.yandex.travel.hotels.common.encryption;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;

import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class EncryptionService {
    private final static String KEY_ALGORITHM = "AES";
    private final static String CIPHER_ALGORITHM = "AES/GCM/NoPadding";
    private final static String HASH_ALGORITHM = "SHA-1";
    private final static int IV_LENGTH = 12;
    private final static int KEY_LENGTH = 16;
    private final static int HEADER_LENGTH = 16;
    private final static String DEFAULT_ENCODING = "UTF-8";
    private final SecretKeySpec keySpec;
    private final SecureRandom random;

    public EncryptionService(String symmetricEncryptionKey) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        random = new SecureRandom();
        MessageDigest sha = MessageDigest.getInstance(HASH_ALGORITHM);
        byte[] keyBytes = sha.digest(symmetricEncryptionKey.getBytes(DEFAULT_ENCODING));
        keyBytes = Arrays.copyOf(keyBytes, KEY_LENGTH);
        keySpec = new SecretKeySpec(keyBytes, KEY_ALGORITHM);
    }

    public byte[] encrypt(byte[] input) {
        try {
            byte[] iv = new byte[IV_LENGTH];
            random.nextBytes(iv);
            GCMParameterSpec gcmSpec = new GCMParameterSpec(HEADER_LENGTH * 8, iv);
            Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
            cipher.init(Cipher.ENCRYPT_MODE, keySpec, gcmSpec);
            byte[] body = cipher.doFinal(input);
            byte[] result = new byte[iv.length + body.length];
            System.arraycopy(iv, 0, result, 0, iv.length);
            System.arraycopy(body, 0, result, iv.length, body.length);
            return result;
        } catch (Exception ex) {
            throw new RuntimeException("Encryption failed", ex);
        }
    }

    public byte[] decrypt(byte[] input) {
        try {
            byte[] iv = Arrays.copyOf(input, IV_LENGTH);
            byte[] body = Arrays.copyOfRange(input, IV_LENGTH, input.length);
            GCMParameterSpec gcmSpec = new GCMParameterSpec(HEADER_LENGTH * 8, iv);
            Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
            cipher.init(Cipher.DECRYPT_MODE, keySpec, gcmSpec);
            return cipher.doFinal(body);
        } catch (Exception ex) {
            throw new RuntimeException("Decryption failed", ex);
        }
    }
}
