package ru.yandex.travel.hotels.common.promo.mir;

import java.util.function.Function;

import lombok.extern.slf4j.Slf4j;

import ru.yandex.travel.commons.health.HealthChecked;
import ru.yandex.travel.hotels.proto.EPartnerId;
import ru.yandex.travel.hotels.proto.THotelId;
import ru.yandex.travel.hotels.proto.TMirWhitelistRecord;
import ru.yandex.travel.yt_lucene_index.MapPersistentConfig;

@Slf4j
public class MirHotelListImpl extends MapPersistentConfig<THotelId, TMirWhitelistRecord, TMirWhitelistRecord>
        implements MirHotelList, HealthChecked {

    public MirHotelListImpl(MirHotelListProperties params) {
        super(params, "mir_promo_hotels", TMirWhitelistRecord::newBuilder,
                r -> THotelId.newBuilder()
                        .setOriginalId(r.getOriginalId())
                        .setPartnerId(r.getPartnerId())
                        .build(),
                Function.identity());
    }

    @Override
    public String getMirIdIfEnabled(EPartnerId partnerId, String hotelId) {
        var item = getByKey(THotelId.newBuilder().setPartnerId(partnerId).setOriginalId(hotelId).build());
        if (item == null) {
            log.info("Hotel {} for partner {} is unlisted for MIR promo", hotelId, partnerId.toString());
            return null;
        } else {
            if (item.getEnabled()) {
                return item.getMirId();
            } else {
                return null;
            }
        }
    }

    @Override
    public boolean isHealthy() {
        return this.isReady();
    }
}
