package ru.yandex.travel.hotels.common.promo.mir;

import java.math.BigDecimal;
import java.time.Instant;
import java.util.Map;

import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

import lombok.Data;

@Data
public class MirProperties {
    @Valid
    private MirHotelListProperties whitelist;
    @NotNull
    @NotEmpty
    @Valid
    private Map<String, Stage> stages;

    @Data
    public static class Stage {
        @NotNull
        private Instant stageStarts;
        @NotNull
        private Instant stageEnds;

        private Instant firstCheckin;
        private Instant lastCheckout;

        @Min(1)
        private int minLOS;
        @NotNull
        private BigDecimal cashbackRate;
        @NotNull
        private BigDecimal maxCashbackAmount;
    }

}
