package ru.yandex.travel.hotels.common.promo.mir;

import java.time.LocalDate;
import java.time.temporal.ChronoUnit;

import org.jetbrains.annotations.NotNull;

import ru.yandex.travel.hotels.proto.TGetActivePromosRsp;
import ru.yandex.travel.hotels.proto.TMirPromoParams;

public class MirUtils {
    private static TMirPromoParams getMirFromActivePromos(TGetActivePromosRsp activePromos) {
        if (activePromos == null || !activePromos.hasMir()) {
            return null;
        }
        return activePromos.getMir();
    }

    public static boolean isActive(TGetActivePromosRsp activePromos) {
        return isActive(getMirFromActivePromos(activePromos));
    }

    public static boolean isActive(TMirPromoParams mirPromo) {
        return mirPromo != null && mirPromo.getActive();
    }

    public static boolean areDatesEligible(TGetActivePromosRsp activePromos, @NotNull LocalDate checkin, @NotNull LocalDate checkout) {
        return areDatesEligible(getMirFromActivePromos(activePromos), checkin, checkout);
    }

    public static boolean areDatesEligible(TMirPromoParams mirPromo, @NotNull LocalDate checkin, @NotNull LocalDate checkout) {
        if (!isActive(mirPromo)) {
            return false;
        }
        if (ChronoUnit.DAYS.between(checkin, checkout) < mirPromo.getMinNights()) {
            return false;
        }
        LocalDate mirLastCheckout = LocalDate.parse(mirPromo.getLastCheckOut());
        if (checkout.isAfter(mirLastCheckout)) {
            return false;
        }
        LocalDate mirFirstCheckin = LocalDate.parse(mirPromo.getFirstCheckIn());
        if (checkin.isBefore(mirFirstCheckin)) {
            return false;
        }
        return true;
    }
}
