package ru.yandex.travel.hotels.common.promo.mir;

import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;

public class MirWhitelistHealthIndicator implements HealthIndicator {
    private final MirHotelListImpl hotelList;

    public MirWhitelistHealthIndicator(MirHotelListImpl hotelList) {
        this.hotelList = hotelList;
    }

    @Override
    public Health health() {
        if (hotelList.isReady()) {
            return Health.up().build();
        } else {
            return Health.down().build();
        }
    }
}
