package ru.yandex.travel.hotels.common.promo.mir;

import javax.validation.constraints.NotNull;

import ru.yandex.travel.commons.health.HealthCheckedSupplier;
import ru.yandex.travel.hotels.proto.EPartnerId;

public class MirWhitelistSupplier extends HealthCheckedSupplier<MirHotelListImpl> implements MirHotelList {
    private MirHotelListImpl wrapped;

    public MirWhitelistSupplier(@NotNull MirHotelListImpl wrapped) {
        super(wrapped, "mirWhiteList");
        this.wrapped = wrapped;
    }

    @Override
    public String getMirIdIfEnabled(EPartnerId partnerId, String hotelId) {
        return get().join().getMirIdIfEnabled(partnerId, hotelId);
    }

    public void close() {
        this.wrapped.stop();
    }
}
