package ru.yandex.travel.hotels.common.schedule;

import java.util.List;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Singular;
import lombok.Value;

import ru.yandex.travel.hotels.proto.TPaymentSchedule;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = OfferPaymentSchedule.OfferPaymentScheduleBuilder.class)
public class OfferPaymentSchedule {
    private OfferPaymentScheduleItem initialPayment;
    @Singular
    private List<OfferPaymentScheduleItem> deferredPayments;

    public TPaymentSchedule toProto() {
        var builder = TPaymentSchedule.newBuilder()
                .setInitialPayment(initialPayment.toProto());
        for (var payment : deferredPayments) {
            builder.addDeferredPayments(payment.toProto());
        }
        return builder.build();
    }

    @JsonPOJOBuilder(withPrefix = "")
    public static class OfferPaymentScheduleBuilder {
    }
}



