package ru.yandex.travel.hotels.common.schedule;

import java.math.BigDecimal;
import java.time.Instant;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;
import org.javamoney.moneta.Money;

import ru.yandex.misc.lang.StringUtils;
import ru.yandex.travel.commons.proto.ProtoUtils;
import ru.yandex.travel.hotels.proto.TScheduledPayment;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = OfferPaymentScheduleItem.OfferPaymentScheduleItemBuilder.class)
public class OfferPaymentScheduleItem {
    private String name;
    private Money amount;
    private BigDecimal ratio;
    private Instant paymentEndsAt;
    private Money penaltyIfUnpaid;
    private boolean ratioIsStandard;

    public TScheduledPayment toProto() {
        var builder = TScheduledPayment.newBuilder()
                .setAmount(ProtoUtils.toTPrice(amount))
                .setRate(ratio.doubleValue());
        if (StringUtils.isNotBlank(name)) {
            builder.setName(name);
        }
        if (paymentEndsAt != null) {
            builder.setPaymentEndsAt(ProtoUtils.fromInstant(paymentEndsAt));
        }
        return builder.build();
    }

    @JsonPOJOBuilder(withPrefix = "")
    public static class OfferPaymentScheduleItemBuilder {
    }
}
