package ru.yandex.travel.hotels.common.schedule;

import java.util.Map;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.validation.annotation.Validated;

import ru.yandex.travel.yt_lucene_index.YtLuceneIndexParams;


@EqualsAndHashCode(callSuper = true)
@Data
@Validated
public class PaymentScheduleHotelListProperties extends YtLuceneIndexParams {
    private Map<@Pattern(regexp = "bnovo|expedia|travelline|dolphin|bronevik") @NotNull String, @NotNull ListMode> partnerModes;
    private boolean enabled;

    public enum ListMode {
        WHITE,
        BLACK
    }

}
