package ru.yandex.travel.hotels.common.token;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

import lombok.EqualsAndHashCode;

@EqualsAndHashCode
public class Occupancy {
    private int adults = 0;
    private List<Integer> children = new ArrayList<>();

    private Occupancy() {
    }

    public static Occupancy fromString(String s) {
        if (s.isEmpty()) {
            throw new RuntimeException(String.format("Invalid occupancy '%s'", s));
        }
        String[] parts = s.split("-", 2);
        Occupancy result = new Occupancy();
        result.adults = Integer.parseInt(parts[0]);
        if (parts.length > 1) {
            String[] ages = parts[1].split(",");
            for (String age : ages) {
                result.children.add(Integer.parseInt(age));
            }
            Collections.sort(result.children);
        }
        return result;
    }

    public int getAdults() {
        return adults;
    }

    public List<Integer> getChildren() {
        return children;
    }

    public String getChildrenAsString(CharSequence delim) {
        return getChildren().stream().map(Object::toString).collect(Collectors.joining(delim));
    }

    public String toString() {
        return toStringImpl('\0', '-');
    }

    public String toExpediaString() {
        return toStringImpl('\0', '-');
    }

    public String toBookingString() {
        return toStringImpl('A', ',');
    }

    public String toHotelsCombinedString() {
        return toStringImpl('\0', ':');
    }

    private String toStringImpl(char adultChar, char delimiter) {
        StringBuilder sb = new StringBuilder();
        if (adultChar > 0) {
            for (int i = 0; i < adults; i++) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(adultChar);
            }
        } else {
            sb.append(adults);
        }
        if (!children.isEmpty()) {
            sb.append(delimiter);
            boolean first = true;
            for (int child : children) {
                if (!first) {
                    sb.append(',');
                }
                sb.append(child);
                first = false;
            }
        }
        return sb.toString();
    }
}
