package ru.yandex.travel.hotels.common.token;

import java.util.Base64;

import com.google.protobuf.InvalidProtocolBufferException;
import lombok.RequiredArgsConstructor;

import ru.yandex.travel.hotels.common.encryption.EncryptionService;
import ru.yandex.travel.hotels.proto.TTravelToken;

@RequiredArgsConstructor
public class TokenCodec {
    private final EncryptionService encryptionService;

    public String encode(TravelToken token) {
        byte[] tokenBytes = token.getProtoToken().toByteArray();
        byte[] encryptedTokenBytes;
        try {
            encryptedTokenBytes = encryptionService.encrypt(tokenBytes);
        } catch (Exception ex) {
            throw new TokenException("Unable to encrypt token", ex);
        }
        return Base64.getUrlEncoder().encodeToString(encryptedTokenBytes);
    }

    public TravelToken decode(String tokenString) {
        byte[] tokenBytes;
        try {
            byte[] encryptedTokenBytes = Base64.getUrlDecoder().decode(tokenString);
            tokenBytes = encryptionService.decrypt(encryptedTokenBytes);
        } catch (Exception ex) {
            throw new TokenException("Unable to decrypt token", ex);
        }
        try {
            return TravelToken.fromProto(TTravelToken.parseFrom(tokenBytes));
        } catch (InvalidProtocolBufferException ex) {
            throw new TokenException("Unable to parse token", ex);
        }
    }
}
