package ru.yandex.travel.hotels.common.validators;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import javax.validation.Constraint;
import javax.validation.Payload;

@Documented
@Constraint(validatedBy = OneOfNotNullValidator.class)
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
public @interface OneOfNotNull {
    String[] fieldNames();
    boolean exactlyOne() default false;

    String message();

    Class<? extends Payload>[] payload() default {};

    Class<?>[] groups() default {};

    @Target({ElementType.TYPE})
    @Retention(RetentionPolicy.RUNTIME)
    @interface List {
        OneOfNotNull[] value();
    }
}
