package ru.yandex.travel.hotels.common.validators;

import java.util.HashSet;
import java.util.Set;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

import org.springframework.beans.BeanWrapperImpl;

public class OneOfNotNullValidator implements ConstraintValidator<OneOfNotNull, Object> {
    private Set<String> fieldNames;
    private boolean exactlyOne;


    @Override
    public void initialize(OneOfNotNull constraintAnnotation) {
        this.fieldNames = Set.of(constraintAnnotation.fieldNames());
        this.exactlyOne = constraintAnnotation.exactlyOne();
    }

    @Override
    public boolean isValid(Object value, ConstraintValidatorContext context) {
        var o = new BeanWrapperImpl(value);
        Set<String> notNullFields = new HashSet<>();
        for (var fieldName : fieldNames) {
            var v = o.getPropertyValue(fieldName);
            if (v != null) {
                notNullFields.add(fieldName);
                if (!exactlyOne) {
                    return true;
                }
            }
        }
        if (exactlyOne) {
            if (notNullFields.size() != 1) {
                context.disableDefaultConstraintViolation();
                context
                        .buildConstraintViolationWithTemplate(String.format("Exactly one of %s must be not null. Actually" +
                                " %s are not null", fieldNames, notNullFields))
                        .addConstraintViolation();
            } else {
                return true;
            }
        }
        return false;
    }
}
