package ru.yandex.travel.hotels.geosearch;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

import ru.yandex.travel.commons.http.HttpServiceProperties;

@ConfigurationProperties(value = "geo-search", ignoreUnknownFields = false)
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
@Validated
public class GeoSearchProperties extends HttpServiceProperties {
    private String tvmDestinationAlias;
    private String offerCacheAddress;
    private String prodOfferCacheAddress;
    private double retryRateLimit = 0.3;
}
