package ru.yandex.travel.hotels.geosearch.model;

import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Getter;

import ru.yandex.travel.commons.http.CommonHttpHeaders;

@AllArgsConstructor(access = AccessLevel.PRIVATE)
public class Attribution {
    @Getter
    private final String yandexUid;
    @Getter
    private final String passportUid;
    @Getter
    private final String icookieDecrypted;
    @Getter
    private final String userIp;

    public static Attribution fromHeaders(CommonHttpHeaders headers) {
        return new Attribution(headers.getYandexUid(), headers.getPassportId(), headers.getICookieDecrypted(), headers.getUserIP());
    }
}
