package ru.yandex.travel.hotels.geosearch.model;

import java.util.List;

import lombok.Data;
import yandex.maps.proto.common2.geo_object.GeoObjectOuterClass;
import yandex.maps.proto.search.business.Business;
import yandex.maps.proto.search.business_rating_2x.BusinessRating2X;
import yandex.maps.proto.search.masstransit_2x.Masstransit2X;
import yandex.maps.proto.search.photos_2x.Photos2X;

import ru.yandex.travel.hotels.common.Permalink;
import ru.yandex.travel.hotels.offercache.api.TReadResp;

@Data
public class GeoHotel {
    // TODO (alexcrush) think about getting rid of all nullable fields here - it is too risky

    // Always present
    private Permalink permalink;
    // Always present
    private GeoObjectOuterClass.GeoObject geoObject;
    // Always present
    private Business.GeoObjectMetadata geoObjectMetadata;
    // Present if Req.includePhotos == true
    private Photos2X.GeoObjectMetadata photos;
    // Present if Req.includeSpravPhotos == true
    private List<GeoHotelPhoto> spravPhotos;
    // Present if Req.includeRating == true
    private BusinessRating2X.BusinessRatingMetadata rating;
    // Present only when req.includeOfferCache == true
    private TReadResp.THotel offerCacheResponse;
    // Present only when req.includeLegalInfo == true
    private GeoHotelLegalInfo legalInfo;
    // Present only when req.includeUgcAnswers == true
    private GeoHotelUgcFeatures ugcFeatures;
    // Present only when req.includeSimilarHotels == true
    private List<GeoSimilarHotel> similarHotels;
    // present only when req.includeNearByStops == true
    private Masstransit2X.NearbyStopsMetadata nearByStops;
    // present only when req.includeFeatureGroups == true
    private List<GeoHotelFeatureGroup> featureGroups;
    // present only when req.includeCategoryIds == true
    private List<String> categoryIds;

    public int getNumStars() {
        for (Business.Feature feature : getGeoObjectMetadata().getFeatureList()) {
            if (feature.getId().equals("star") && feature.getValue().getEnumValueCount() > 0) {
                String starsText = feature.getValue().getEnumValue(0).getName();
                if (starsText.length() > 0 && Character.isDigit(starsText.charAt(0))) {
                    return Character.getNumericValue(starsText.charAt(0));
                }
            }
        }
        return 0;
    }

    public Double getRatingAt0To5Scale() {
        if (getRating() == null) {
            return null;
        }
        return Math.round(getRating().getScore() * 5) / 10d;
    }
}
