package ru.yandex.travel.hotels.geosearch.model;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;

public class GeoHotelLegalInfoDeserializer extends StdDeserializer<GeoHotelLegalInfo> {
    protected GeoHotelLegalInfoDeserializer() {
        super(GeoHotelLegalInfo.class);
    }

    @Override
    public GeoHotelLegalInfo deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        GeoHotelLegalInfo legalInfo = new GeoHotelLegalInfo();
        JsonNode root = p.getCodec().readTree(p);
        legalInfo.setInn(getTextOrEmpty(root, "inn"));
        legalInfo.setOgrn(getTextOrEmpty(root, "ogrn"));
        JsonNode legalNameNode = root.get("name");
        if (legalNameNode != null) {
            legalInfo.setName(legalNameNode.get("value").textValue());
        }
        JsonNode legalAddressNode = root.at("/address/formatted");
        if (legalAddressNode != null) {
            legalInfo.setAddress(getTextOrEmpty(legalAddressNode, "value"));
        }
        return legalInfo;
    }

    private String getTextOrEmpty(JsonNode node, String name) {
        if (node!= null && node.has(name)) {
            return node.get(name).textValue();
        }
        return "";
    }
}
