package ru.yandex.travel.hotels.geosearch.model;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;

import lombok.Data;
import yandex.maps.proto.search.business.Business;
import yandex.maps.proto.search.search.Search;
import yandex.maps.proto.search.search_internal.SearchInternal;

import ru.yandex.travel.hotels.offercache.api.TReadResp;

@Data
public class GeoSearchRsp {
    private boolean isNotImplementedError;
    // not always present, may be missing if isNotImplementedError
    private Search.SearchResponseMetadata responseMetadata;
    // not always present, may be missing if isNotImplementedError
    private SearchInternal.SearchResponseInfo responseInfo;
    // not always!
    private Business.ResponseMetadata businessMetadata;
    // Present only when req.includeOfferCache == true
    private TReadResp offerCacheResponseMetadata;
    // Present only when req.includeSortStats == true
    private TravelSortStats travelSortStats;
    // always present
    private List<GeoHotel> hotels = new ArrayList<>();

    // Profiling data
    private Duration responseTime;
    private Duration parseTime;
}
