package ru.yandex.travel.hotels.geosearch.model;

import java.util.List;

import lombok.Data;
import yandex.maps.proto.search.related_places.RelatedPlaces;

import ru.yandex.travel.hotels.common.Permalink;
import ru.yandex.travel.hotels.offercache.api.TReadResp;

@Data
public class GeoSimilarHotel {
    @Data
    public static class Feature {
        private String id;
        private String name;
        private boolean isMain;
        private Boolean boolValue;
        private String stringValue;
        private List<String> enumValues;
    }

    @Data
    public static class Extension {
        private List<Feature> features;
        private int ratingCount;
        private double ratingScore;
        private int reviewCount;
        private int stars;
    }

    // Always present
    private Permalink permalink;
    // Always present
    private RelatedPlaces.PlaceInfo placeInfo;
    // Only if Req.includeOfferCache == true
    private TReadResp.THotel offerCacheResponse;
    // Only if Req.includeOfferCache == true
    private Extension extension;

    public Double getRatingAt0To5Scale() {
        if (getExtension() == null) {
            return null;
        }
        return Math.round(getExtension().getRatingScore() * 5) / 10d;
    }
}
