package ru.yandex.travel.hotels.geosearch.model;

import java.time.LocalDate;
import java.util.List;

import lombok.AllArgsConstructor;
import lombok.Data;
import org.asynchttpclient.RequestBuilder;

import ru.yandex.travel.hotels.common.Ages;
import ru.yandex.travel.hotels.geosearch.util.ProtoUtils;
import ru.yandex.travel.hotels.offercache.api.TReadReq;

@Data
@AllArgsConstructor
public class OfferCacheRequestParams {
    private TReadReq request;

    public static OfferCacheRequestParams build(TReadReq.Builder b) {
        return new OfferCacheRequestParams(b.build());
    }

    public static TReadReq.Builder prepareBuilder(LocalDate checkinDate, LocalDate checkoutDate,
                                                  Integer numAdults, List<Integer> childrenAges,
                                                  boolean useSearcher, String debugId, boolean hasSearchParams,
                                                  boolean sortOffersUsingPlus) {
        TReadReq.Builder b = TReadReq.newBuilder();
        if (checkinDate != null) {
            b.setCheckInDate(checkinDate.toString());
            if (checkoutDate != null) {
                b.setCheckOutDate(checkoutDate.toString());
            }
        }
        if (numAdults != null) {
            String agesString = Ages.build(numAdults, childrenAges).toString();
            b.setAges(agesString);
        }
        if (useSearcher) {
            b.setUseSearcher(true);
            b.setRequestId(0);
        }
        b.getAttributionBuilder().setYaTravelDebugId(debugId);
        b.setHasSearchParams(hasSearchParams);
        b.setSortOffersUsingPlus(sortOffersUsingPlus);
        return b;
    }

    public static OfferCacheRequestParams build(LocalDate checkinDate, LocalDate checkoutDate,
                                                Integer numAdults, List<Integer> childrenAges,
                                                boolean useSearcher, String debugId, boolean sortOffersUsingPlus) {
        return build(prepareBuilder(checkinDate, checkoutDate, numAdults, childrenAges, useSearcher, debugId, true, sortOffersUsingPlus));
    }

    public void putToQueryParams(RequestBuilder builder) {
        ProtoUtils.protoToQueryParams(request, builder, "middle_yandex_travel_");
    }

    public void putToQueryParamsAsDynamic(RequestBuilder builder) {
        builder.addQueryParam("ag_dynamic", ProtoUtils.protoToJSONWithPrefix(request, "middle_yandex_travel_"));
    }
}
