package ru.yandex.travel.hotels.geosearch.model;

import lombok.Data;

@Data
public class TravelSortStats {

    @Data
    public static class ByFactorsStats {
        private boolean enabled;
        private boolean ascending;
        private int docsCount;
        private int docsWithFactorCount;
    }

    @Data
    public static class BySnippetsStats {

        @Data
        public static class OffsetCountsStats {
            private int lessThan10;
            private int zero;
        }

        @Data
        public static class OffsetDistributionStats {
            private int max;
            private int p50;
            private int p90;
            private int p95;
        }

        @Data
        public static class RealtimeDataCompletenessStats {
            private int prefixFinishedHotelsSize;
            private int prefixFoundHotelsSize;
            private int prefixPricesSize;
            private int prefixSnippetsSize;
            private int totalFinishedHotelsCount;
            private int totalFoundHotelsCount;
            private int totalPricesCount;
            private int totalSnippetsCount;
        }

        private boolean enabled;
        private boolean ascending;
        private int docsCount;
        private OffsetCountsStats OffsetCounts;
        private OffsetDistributionStats OffsetDistribution;
        private RealtimeDataCompletenessStats RealtimeDataCompleteness;
    }

    private ByFactorsStats byFactors;
    private BySnippetsStats bySnippets;
    private String type;
}
