package ru.yandex.travel.hotels.models.booking_flow;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum BreakdownType {
    NIGHT("night"),
    DAY("day"),
    NONE("none");

    private final String value;

    BreakdownType(String value) {
        this.value = value;
    }

    @JsonCreator
    public static BreakdownType fromString(String value) {
        for (var candidate : BreakdownType.values()) {
            if (candidate.value.equals(value)) {
                return candidate;
            }
        }
        throw new IllegalArgumentException(
                String.format("Unknown BreakdownType %s", value)
        );
    }

    @JsonValue
    public String getValue() {
        return value;
    }
}
