package ru.yandex.travel.hotels.models.booking_flow;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

import ru.yandex.travel.hotels.common.LocationType;


@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = HotelInfo.HotelInfoBuilder.class)
@JsonIgnoreProperties({"breadcrumbs"})
public class HotelInfo {
    private long permalink;
    private String name;
    private String phone;
    private String address;
    private Integer stars;
    private Float rating;
    private Coordinates coordinates;
    private String imageUrlTemplate;
    private String workingHours;
    private LocationType locationType;

    @JsonPOJOBuilder(withPrefix = "")
    public static class HotelInfoBuilder {
    }
}
