package ru.yandex.travel.hotels.models.booking_flow;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = LegalInfo.LegalInfoBuilder.class)
public class LegalInfo {
    private LegalInfoItem hotel;
    private LegalInfoItem yandex;
    private LegalInfoItem partner;

    @JsonPOJOBuilder(withPrefix = "")
    public static class LegalInfoBuilder {
    }

    @Value
    @Builder(toBuilder = true)
    @JsonDeserialize(builder = LegalInfoItem.LegalInfoItemBuilder.class)
    public static class LegalInfoItem {
        private String name;
        private String ogrn;
        private String actualAddress;
        private String legalAddress;
        private String workingHours;
        private String registryNumber;

        @JsonPOJOBuilder(withPrefix = "")
        public static class LegalInfoItemBuilder {

        }
    }
}
