package ru.yandex.travel.hotels.models.booking_flow;

import java.time.LocalDateTime;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = MetaInfo.MetaInfoBuilder.class)
public class MetaInfo {
    private SearchInfo search;
    private String token;
    private String tokenId;
    private String label;
    private LocalDateTime offerGeneratedAt;
    private String checkSum;
    private String deduplicationKey;
    private Integer selectedBedGroupIndex;
    private Boolean directPartner;


    @JsonPOJOBuilder(withPrefix = "")
    public static class MetaInfoBuilder {
    }
}
