package ru.yandex.travel.hotels.models.booking_flow;

import java.util.List;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.NoArgsConstructor;
import lombok.Singular;
import lombok.Value;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = PartnerHotelInfo.PartnerHotelInfoBuilder.class)
public class PartnerHotelInfo {
    private String name;
    private String address;
    private Coordinates coordinates;
    private Integer stars;
    private String phone;
    @Singular
    private List<Amenity> amenities;
    @Singular
    private List<TextBlock> descriptions;
    @Singular
    private List<Image> images;

    @JsonPOJOBuilder(withPrefix = "")
    public static class PartnerHotelInfoBuilder {
    }

    @Value
    @AllArgsConstructor
    @NoArgsConstructor(force = true, access = AccessLevel.PRIVATE)
    public static class TextBlock {
        private String header;
        private String text;
    }
}


