package ru.yandex.travel.hotels.models.booking_flow;

import java.math.BigDecimal;
import java.math.RoundingMode;

import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.NoArgsConstructor;
import lombok.Value;
import org.javamoney.moneta.Money;

import ru.yandex.travel.commons.proto.ProtoCurrencyUnit;

@Value
@NoArgsConstructor(force = true, access = AccessLevel.PRIVATE)
@AllArgsConstructor()
public class Rate {
    private String amount;
    private String currency;

    public Money asMoney() {
        //noinspection ConstantConditions
        return Money.of(new BigDecimal(amount), ProtoCurrencyUnit.fromCurrencyCode(currency));
    }

    public static Rate fromMoney(Money amount) {
        return new Rate(amount.getNumberStripped().setScale(2, RoundingMode.HALF_UP).toString(), amount.getCurrency().getCurrencyCode());
    }
}
