package ru.yandex.travel.hotels.models.booking_flow;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Builder;
import lombok.Data;
import lombok.extern.jackson.Jacksonized;
import org.javamoney.moneta.Money;

@Data
@Builder(toBuilder = true)
@Jacksonized
public class RateInfo {
    private Rate baseRate;
    private BreakdownType breakdownType;
    private List<Rate> baseRateBreakdown;
    private Rate taxesAndFees;
    private Rate totalRate;
    private List<ExtraFee> extraFees;
    private RateStatus status;
    private Money priceAfterPlusWithdraw;

    @JsonIgnore
    public Money getTotalMoney() {
        return totalRate != null ? totalRate.asMoney() : null;
    }
}
