package ru.yandex.travel.hotels.models.booking_flow;

import java.math.BigDecimal;

public enum RateStatus {
    CONFIRMED,
    PRICE_MISMATCH,
    PRICE_MISMATCH_UP,
    PRICE_MISMATCH_DOWN,
    SOLD_OUT;

    public static RateStatus fromComparison(BigDecimal cachedPrice, BigDecimal actualPrice) {
        RateStatus status = null;

        switch (actualPrice.compareTo(cachedPrice)) {
            case 0:
                status = RateStatus.CONFIRMED;
                break;
            case 1:
                status = RateStatus.PRICE_MISMATCH_UP;
                break;
            case -1:
                status = RateStatus.PRICE_MISMATCH_DOWN;
                break;
        }

        return status;
    }
}
