package ru.yandex.travel.hotels.models.booking_flow;

import java.util.List;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Singular;
import lombok.Value;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = RoomInfo.RoomInfoBuilder.class)
public class RoomInfo {
    private String name;
    private String description;
    @Singular
    private List<Image> images;
    private LocalizedPansionInfo pansionInfo;
    private List<Amenity> roomAmenities;
    private List<BedGroupInfo> bedGroups;

    @JsonPOJOBuilder(withPrefix = "")
    public static class RoomInfoBuilder {
    }
}
