package ru.yandex.travel.hotels.models.booking_flow;

import java.time.LocalDate;
import java.util.List;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

import ru.yandex.travel.hotels.proto.EPartnerId;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = SearchInfo.SearchInfoBuilder.class)
public class SearchInfo {
    private LocalDate checkIn;
    private LocalDate checkOut;
    private int adults;
    private List<Integer> children;
    private long permalink;
    private EPartnerId partnerId;
    private String originalId;

    @JsonPOJOBuilder(withPrefix = "")
    public static class SearchInfoBuilder {
    }
}
