package ru.yandex.travel.hotels.models.booking_flow;

import java.util.List;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Singular;
import lombok.Value;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = StayInfo.StayInfoBuilder.class)
public class StayInfo {
    private String checkInStartTime;
    private String checkInEndTime;
    private String checkOutStartTime;
    private String checkOutEndTime;
    @Singular
    private List<String> stayInstructions;
    private String rateDescriptionForSupport;

    @JsonPOJOBuilder(withPrefix = "")
    public static class StayInfoBuilder {
    }
}
