package ru.yandex.travel.hotels.models.booking_flow.promo;

import java.math.BigDecimal;
import java.time.Instant;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

import ru.yandex.travel.hotels.proto.EMirEligibility;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = Mir2020PromoCampaign.Mir2020PromoCampaignBuilder.class)
public class Mir2020PromoCampaign {
    private EMirEligibility eligibility;
    private Instant expiresAt;
    private String mirId;
    private Integer cashbackAmount;
    private BigDecimal cashbackRate;
    private Boolean displayAmount;


    @JsonPOJOBuilder(withPrefix = "")
    public static class Mir2020PromoCampaignBuilder {
    }
}
