package ru.yandex.travel.hotels.models.booking_flow.promo;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

import ru.yandex.travel.hotels.proto.EWhiteLabelEligibility;
import ru.yandex.travel.white_label.proto.EWhiteLabelPartnerId;
import ru.yandex.travel.white_label.proto.EWhiteLabelPointsType;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = WhiteLabelPromoCampaign.WhiteLabelPromoCampaignBuilder.class)
public class WhiteLabelPromoCampaign {
    EWhiteLabelEligibility eligible;
    EWhiteLabelPartnerId partnerId;
    WhiteLabelPoints points;
    WhiteLabelPointsLinguistics pointsLinguistics;

    @Value
    @Builder(toBuilder = true)
    @JsonDeserialize(builder = WhiteLabelPoints.WhiteLabelPointsBuilder.class)
    public static class WhiteLabelPoints {
        Integer amount;
        EWhiteLabelPointsType pointsType;

        @JsonPOJOBuilder(withPrefix = "")
        public static class WhiteLabelPointsBuilder {
        }
    }

    @Value
    @Builder(toBuilder = true)
    @JsonDeserialize(builder = WhiteLabelPointsLinguistics.WhiteLabelPointsLinguisticsBuilder.class)
    public static class WhiteLabelPointsLinguistics {
        String nameForNumeralNominative;

        @JsonPOJOBuilder(withPrefix = "")
        public static class WhiteLabelPointsLinguisticsBuilder {
        }
    }

    @JsonPOJOBuilder(withPrefix = "")
    public static class WhiteLabelPromoCampaignBuilder {
    }
}
