package ru.yandex.travel.hotels.models.booking_flow.promo;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;
import org.javamoney.moneta.Money;

import ru.yandex.travel.hotels.proto.EYandexEdaEligibility;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = YandexEdaPromoCampaign.YandexEdaPromoCampaignBuilder.class)
public class YandexEdaPromoCampaign {
    EYandexEdaEligibility eligible;
    YandexEdaPromocodePayload data;

    @Value
    @Builder(toBuilder = true)
    public static class YandexEdaPromocodePayload {
        Integer numberOfPromocodes;
        Money promocodeCost;
        String firstSendDate;
        String lastSendDate;
    }

    @JsonPOJOBuilder(withPrefix = "")
    public static class YandexEdaPromoCampaignBuilder {
    }
}
