package ru.yandex.travel.hotels.common.orders;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

import ru.yandex.travel.hotels.common.partners.bnovo.model.Stay;
import ru.yandex.travel.hotels.common.token.Occupancy;
import ru.yandex.travel.hotels.proto.EPartnerId;

@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
@NoArgsConstructor
public class BNovoHotelItinerary extends HotelItinerary {
    private long accountId;
    private Stay bNovoStay;
    private String yandexNumber;
    private String bNovoNumber;
    private String yandexNumberPrefix;
    private Occupancy occupancy;

    @Override
    public EPartnerId getPartnerId() {
        return EPartnerId.PI_BNOVO;
    }
}
