package ru.yandex.travel.hotels.common.orders;

import java.math.BigDecimal;
import java.math.RoundingMode;

import lombok.AllArgsConstructor;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import org.javamoney.moneta.Money;

import ru.yandex.travel.commons.proto.ProtoCurrencyUnit;
import ru.yandex.travel.commons.proto.TPrice;

@Getter @Setter
@NoArgsConstructor @AllArgsConstructor
@EqualsAndHashCode
public class BaseRate {
    private String amount;
    private String currency;

    public static BaseRate fromTPrice(TPrice price) {
        var value = BigDecimal.valueOf(price.getAmount(), price.getPrecision());
        var res = new BaseRate();
        res.setAmount(value.setScale(2, RoundingMode.HALF_UP).toString());
        res.setCurrency(ProtoCurrencyUnit.fromProtoCurrencyUnit(price.getCurrency()).getCurrencyCode());
        return res;
    }

    public Money asMoney() {
        return Money.of(new BigDecimal(amount), currency);
    }
}
