package ru.yandex.travel.hotels.common.orders;

import java.util.List;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;
import lombok.experimental.SuperBuilder;

import ru.yandex.travel.hotels.proto.EPartnerId;

@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
@NoArgsConstructor
@AllArgsConstructor
@SuperBuilder
public class BronevikHotelItinerary extends HotelItinerary {
    private Integer hotelId;
    private String offerCode;
    private List<Integer> meals;
    private String currency;
    private Integer orderId;
    private String yandexNumber;
    private String yandexNumberPrefix;

    @Override
    public EPartnerId getPartnerId() {
        return EPartnerId.PI_BRONEVIK;
    }
}
