package ru.yandex.travel.hotels.common.orders;

import java.util.ArrayList;
import java.util.List;

import lombok.Data;

@Data
public class CancellationDetails {
    public enum Reason {
        FX_RATE_EXPIRED,
        PRICE_CHANGED,
        SOLD_OUT,
        INVALID_INPUT,
        HOLD_EXPIRED,
        DUPLICATE,
        BLACKLISTED,
        USER_INTENTION,
        HOTEL_INTENTION,
        AGREEMENT_ISSUE,
        MONEY_ACQUIRE_ERROR,
        PROMO_ERROR,
        ADMIN_INTENTION,
        UNKNOWN
    }

    public enum ValidatedFieldType {
        EMAIL,
        PHONE,
        COUNTRY_CODE,
        FIRST_NAME,
        LAST_NAME
    }

    @Data
    public static class InvalidField {
        private ValidatedFieldType fieldType;
        private Integer guestIndex;
    }

    private Reason reason;
    private List<InvalidField> invalidInputDetails;

    public static CancellationDetails create(Reason reason) {
        var res = new CancellationDetails();
        res.setReason(reason);
        if (reason == Reason.INVALID_INPUT) {
            res.setInvalidInputDetails(new ArrayList<>());
        }
        return res;
    }

    public static CancellationDetails create(String reason) {
        return create(Reason.valueOf(reason));
    }
}
