package ru.yandex.travel.hotels.common.orders;

import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.List;
import java.util.UUID;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

import ru.yandex.travel.hotels.common.partners.dolphin.model.DolphinRefundParams;
import ru.yandex.travel.hotels.common.token.Occupancy;
import ru.yandex.travel.hotels.proto.EPartnerId;

@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
@NoArgsConstructor
public class DolphinHotelItinerary extends HotelItinerary {
    // input
    private long hotelId;
    private long tourId;
    private long pansionId;
    private long roomId;
    private long roomCatId;
    private LocalDate checkinDate;
    private int nights;
    private List<Integer> beds;
    private Occupancy occupancy;
    private ZoneId hotelZoneId;
    private Instant checkInMoment;
    private DolphinRefundParams refundParams;
    // is set when moved to manual processing
    private UUID manualTicketId;

    @Override
    public EPartnerId getPartnerId() {
        return EPartnerId.PI_DOLPHIN;
    }
}
