package ru.yandex.travel.hotels.common.orders;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;
import lombok.experimental.SuperBuilder;

import ru.yandex.travel.hotels.common.partners.expedia.ApiVersion;
import ru.yandex.travel.hotels.proto.EPartnerId;

@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
@NoArgsConstructor
@AllArgsConstructor
@SuperBuilder
public class ExpediaHotelItinerary extends HotelItinerary {
    private String customerSessionId;
    private String affiliateId;
    private String expediaItineraryId;
    private String hotelId;
    private String roomId;
    private String rateId;
    private String occupancy;
    private String expediaReservationToken;
    private String expediaConfirmationToken;
    private String refundId;
    private String expediaRefundToken;
    private ApiVersion apiVersion;

    public ApiVersion getApiVersion() {
        return apiVersion == null ? ApiVersion.V2_4 : apiVersion;
    }

    @Override
    public EPartnerId getPartnerId() {
        return EPartnerId.PI_EXPEDIA;
    }
}
