package ru.yandex.travel.hotels.common.orders;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Data;

@Data
@Builder(toBuilder = true)
@JsonDeserialize(builder = GeoRegion.GeoRegionBuilder.class)
public class GeoRegion {
    private int geoId;
    private int type;
    private String name;

    @JsonPOJOBuilder(withPrefix = "")
    public static class GeoRegionBuilder {
    }
}
