package ru.yandex.travel.hotels.common.orders;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;
import lombok.NoArgsConstructor;

import ru.yandex.misc.lang.StringUtils;

/**
 * @implNote both firstName and lastName either should be filled or should be left null. 1st guest in the list must have
 * name filled
 */
@Data
@NoArgsConstructor
public class Guest {
    @Nullable
    private String firstName;
    @Nullable
    private String lastName;
    @Nullable
    private Integer age;
    private boolean isChild;

    /**
     * e.g. Alexandr Pushkin
     */
    @JsonIgnore
    public String getFullName() {
        if (!hasFilledName()) {
            return null;
        }
        return firstName + " " + lastName;
    }

    /**
     * e.g. Pushkin Alexandr
     */
    @JsonIgnore
    public String getFullNameReversed() {
        if (!hasFilledName()) {
            return null;
        }
        return lastName + " " + firstName;
    }

    @JsonIgnore
    public boolean hasFilledName() {
        return !StringUtils.isBlank(firstName) && !StringUtils.isBlank(lastName);
    }
}
