package ru.yandex.travel.hotels.common.orders;

import java.util.List;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;
import org.javamoney.moneta.Money;

import ru.yandex.travel.orders.commons.proto.EVat;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = MealData.MealDataBuilder.class)
public class MealData {
    List<MealItem> items;

    @JsonPOJOBuilder(withPrefix = "")
    public static class MealDataBuilder {
    }


    @Value
    @Builder(toBuilder = true)
    @JsonDeserialize(builder = MealItem.MealItemBuilder.class)
    public static class MealItem {
        Money mealPrice;
        String mealName;
        EVat mealVat;

        @JsonPOJOBuilder(withPrefix = "")
        public static class MealItemBuilder {

        }
    }
}

