package ru.yandex.travel.hotels.common.orders;

import java.time.LocalDate;
import java.time.ZoneId;
import java.util.List;

import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Data;

import ru.yandex.travel.hotels.common.LocationType;

@Data
@Builder(toBuilder = true)
@JsonDeserialize(builder = OrderDetails.OrderDetailsBuilder.class)
public class OrderDetails {
    private LocalDate checkinDate;
    private LocalDate checkoutDate;
    private String checkinBegin;
    private String checkinEnd;
    private String checkoutBegin;
    private String checkoutEnd;
    private String hotelName;
    private String roomName;
    private LocationType locationType;
    private Long permalink;
    private String providerId;
    private String originalId;
    private ZoneId hotelTimeZoneId;
    @Nullable
    private List<GeoRegion> hotelGeoRegions;
    private String addressByYandex;
    private String addressByPartner;
    private String hotelPhone;
    private String ratePlanDetails;

    @JsonPOJOBuilder(withPrefix = "")
    public static class OrderDetailsBuilder {
    }

}
